/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.toolkit.dialog;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.dialog.VWTaskModalDialog;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;

public class VWTaskChangePasswordDialog
extends VWTaskModalDialog {
    private VWTaskTabPanel m_mainPanel = null;
    private JPasswordField m_password = null;
    private JPasswordField m_confirmPassword = null;

    public static VWTaskChangePasswordDialog getInstance() {
        Dimension size = VWStringUtils.stringToDimension("335,165");
        if (size == null) {
            size = new Dimension(300, 150);
        }
        return VWTaskChangePasswordDialog.getInstance(size);
    }

    public static VWTaskChangePasswordDialog getInstance(Dimension size) {
        return new VWTaskChangePasswordDialog(VWTaskCore.getInstance().getMainFrame(), new JPanel(), VWResource.EnterPassword, 12, size);
    }

    public String getPassword() {
        return new String(this.m_password.getPassword());
    }

    private VWTaskChangePasswordDialog(Frame parent, JPanel panel, String title, int optionType, Dimension size) {
        super(parent, panel, title, optionType, null, size);
        panel.setLayout(new BorderLayout(10, 10));
        this.m_mainPanel = this.getMainPanel();
        panel.add((Component)this.m_mainPanel, "Center");
    }

    protected void performValidation() throws Exception {
        this.m_mainPanel.validateTextFields();
        String password1 = new String(this.m_password.getPassword());
        String password2 = new String(this.m_confirmPassword.getPassword());
        if (!password1.equals(password2)) {
            throw new VWException("filenet.vw.apps.taskman.wfservices.VWChangeDB2PasswordDialog.PasswordsDoNotMatch", "The passwords do not match.");
        }
    }

    private VWTaskTabPanel getMainPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_password = new JPasswordField();
        this.m_password.setName(VWResource.NewPassword);
        panel.add((Component)new JLabel(this.m_password.getName() + ":"), c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_password, (Object)c, true);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_confirmPassword = new JPasswordField();
        this.m_confirmPassword.setName(VWResource.ConfirmPassword);
        panel.add((Component)new JLabel(this.m_confirmPassword.getName() + ":"), c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_confirmPassword, (Object)c, true);
        return panel;
    }
}

